These boards/servers are available for cheap on eBay and make for great systems. The reason they are cheap is that they came from an IBM datacenter in bulk, where they use a special signed IBM-only BIOS that cannot be upgraded past version 3.2a. This version works fine unless you need a feature from a newer version...

and additionally, there is no BIOS version for these servers that supports Resizable BAR. The only way to get it would be to mod a BIOS, but the signature check prevents modifying the BIOS. Intel Battlemage GPUs REQUIRE Resize BAR to work, so this is why I've done this.

The steps below involve: Updating the IPMI, Disabling the BIOS signature check with a force-upgrade, and Flashing a modified BIOS with Resizable BAR support.

DISCLAIMER:

I am providing several precompiled binaries here that are either running as root on your system or are replacing the underlying firmware of your device. This requires an inherent level of trust of my files. There is always a risk of damaging your system as you are replacing it's firmware. You are taking that risk and I am not responsible if it fails, but I will do my best to help. However, with a bricked BIOS you can reflash from IPMI, so I would say this procedure is relatively safe. You are free to make your own patched BIOS, compile your own executables, etc by looking at the sources below, but modding the BIOS and acquiring all these files is quite annoying, time consuming, and error-prone so I've provided everything here ready-to-go as known-good versions that I have used purely for convenience and to make the process simple to do instead of taking 2 days of digging through forums and compiling and patching files.

Notes: 

I've done this on 2 independent servers (Different CPUs, memory, etc) with success. I went from having a non-working Arc B580 to being able to do video decoding, GPU acceleration, etc after doing this.

It's a good idea to have a way to reinstall your bootloader (e.g. have Proxmox ISO ready) as this wipes all BIOS settings and NVRAM. On my 2 servers however, the BIOS automatically found the proxmox bootloader even after the wipe. I would still recommend doing `proxmox-boot-tool reinit && proxmox-boot-tool refresh` after.

There is a physical jumper in the server (JPME2) that enables manufacturing mode that was previously thought to be required to be moved to do this process. However, this is not the actually case, this process can be done fully in software via IPMI (if you have a FAT32 boot partition big enough to copy files to) without opening the server.

This process CAN be done on other Supermicro motherboards, but you of course will need the BIOS for that board and need to modify it yourself. Bypassing the sign-lock uses a modified flash script that is universal, and the stock BIOS.

The steps below assume you have a general understanding of the server, CLI commands. All steps are to be performed though the IPMI webpage - mostly iKVM remote control and the BIOS/firmware update pages. Read through these steps FULLY before doing them.

1. Flash 4.01 signed BMC firmware via web UI (Maintenance > Firmware Update) BMC\_X10AST2400-C001MS\_20231215\_04.01\_STDsp.bin

2. Shutdown / Set power off to the server

3. Copy the contents of usb\_files to a FAT32 usb and connect it OR a FAT32 boot partition

4. Set power on (from IPMI)

5. boot to UEFI shell (via boot menu F11). If it's not listed, it needs to be enabled first in BIOS at: Boot > UEFI Application Boot Priorities

6. Go to each boot disk by typing `fs0:`, `fs1:` etc until you find the USB, use `dir` to list folder contents to check if you have the right disk

7. run: `flash.nsh X10DRU2.427`

  a. flash.nsh has been modified to force-flash the BIOS even if it is invalid or unsigned. Take care to not flash some random other file.

b. it will fail with secure vaildation error at the end. this is okay.

8. Set power off (from IPMI)

9. Set power on (from IPMI) and do it again:

10. boot to UEFI shell (via boot menu F11).

11. Go to each boot disk by typing `fs0:`, `fs1:` etc until you find the USB, use `dir` to list folder contents to check if you have the right disk

12. run: `flash.nsh X10DRU2.427`

  a. it will fail with secure vaildation error at the end. this is okay.

  b. It will take noticeably longer the second time! This is the actual flash.

  c. All BIOS settings are wiped at this point.

13. Set power off (from IPMI)

14. Set power on (from IPMI)

15. Go to BIOS (Del) and confirm BIOS is v 3.5

  a. The signature check for BIOS is now disabled and you can flash any unsigned BIOS version!

  b. Make any desired changes here as all settings were wiped

16. Continue on if you want Resizable BAR support (required for Intel Arc B-series GPUs, and better performance on others)

17. Go to BIOS

  a. Enable 4G decoding (Advanced > PCIe/PCI/PnP Configuration > Above 4G Decoding)

  b. Disable CSM (Security > Secure Boot Menu > CSM Support, Boot > Boot Mode Select > UEFI)

  c. Save changes

18. Set power off (from IPMI)

19. Update BIOS from IPMI : X10DRU2.427.PATCHED (patched 3.5 with ReBarDxe.ffs and AMI MMTOOL)

  a. You may need to activate BMC license. You can find the license keys for this board online pretty easily, or DM me for details.

  b. Since we are going from 3.5 to patched 3.5, you may keep BIOS settings by hitting "Preserve NVRAM"

  c. The BIOS version will still show as 3.5 after the upgrade. 

20. To enable resize BAR, we must use a CLI application to configure the hidden BIOS setting via NVRAM variable.

  a. If running linux, you normally must compile the application. I've precompiled a dynamically-linked executable for Debian 13 (Proxmox 9), you can get it on your proxmox host easily by doing as root `wget https://fsv.vortex.deck.sh/share/8m4t0zzm1n9q/rebarstate && chmod +x rebarstate && ./rebarstate`

  b. For other distros, the above may work, if not, you can compile easily, you just need cmake, make, and g++ (build-essential package on debian) installed: [https://github.com/xCuri0/ReBarUEFI/wiki/Building#linux-1](https://github.com/xCuri0/ReBarUEFI/wiki/Building#linux-1)

  c. For windows, you can use ReBarState.exe provided.

  d. Set to 32 to enable full ReBar. Make sure your GPU actually supports ReBar!!!

21. Do a normal software reboot

22. ReBar is now enabled! Congrats!

23. The Linux i915 and xe drivers for linux will print a warning on boot if Resize BAR is unavailable.: "Using a reduced BAR size of 256MiB. Consider enabling 'Resizable BAR' or similar, if available in the BIOS." That message should **not** print in `dmesg` if the process was successful.

24. If using A-series intel cards, you can optionally switch from i915 driver to xe driver now with kernel commandline options: i915.force\_probe=!\[PCI-ID\] xe.force\_probe=\[PCI-ID\] . This might disable the media engine though, so maybe don't do this if you are doing video transcoding. 


Sources:

[https://github.com/xCuri0/ReBarUEFI](https://github.com/xCuri0/ReBarUEFI)

[https://github.com/xCuri0/ReBarUEFI/discussions/299](https://github.com/xCuri0/ReBarUEFI/discussions/299)

[https://forums.servethehome.com/index.php?threads/supermicro-6028u-trtp-x10dru-i-barebone-349.30584/page-8#post-414803](https://forums.servethehome.com/index.php?threads/supermicro-6028u-trtp-x10dru-i-barebone-349.30584/page-8#post-414803)

[https://www.phoronix.com/review/intel-i915-xe-linux-2025](https://www.phoronix.com/review/intel-i915-xe-linux-2025)

